<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Product;
use App\Models\Booking;
use App\Models\User;
use Illuminate\Support\Facades\Validator;
use Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class ApiController extends Controller
{
    public function GetCategory()
    {
        $getcategory = Category::select("id", "category_name", "category_image")
            ->where("status", "=", "1")
            ->get();
        if (count($getcategory) != 0) {
            foreach ($getcategory as $value) {
                $response[] = [
                    "id" => $value->id,
                    "category_name" => $value->category_name,
                    "category_image" =>
                        "public/category_images/" . $value->category_image,
                ];
            }
            $result = $response;
        } else {
            $result = ["status" => "0", "message" => "Category is empty"];
        }

        return json_encode($result);
    }
    public function GetProducts($id)
    {
        $getProducts = Product::select(
            "id",
            "product_name",
            "product_category_id as category_id",
            "product_image"
        )
            ->where("product_category_id", "=", $id)
            ->where("status", "=", "1")
            ->get();

        if (count($getProducts) != 0) {
            foreach ($getProducts as $value) {
                $response[] = [
                    "id" => $value->id,
                    "product_name" => $value->product_name,
                    "product_image" =>
                        "public/product_images/" . $value->product_image,
                ];
            }
            $result = $getProducts;
        } else {
            $result = ["status" => "0", "message" => "Products is empty"];
        }

        return json_encode($result);
    }
    public function AddCatgory(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "category_name" => "required",
            "category_image" => "required",
        ])->validate();

        $file = $request->file("category_image");
        $imageName = time() . "." . $file->extension();
        $imagePath = $imageName;
        $file->move("category_images", $imageName);
        if ($file) {
            $category = new Category();
            $category->category_name = $request->input("category_name");
            $category->category_image = $imagePath;
            $category->status = "1";
            if ($category->save()) {
                return response()->json([
                    "status" => 1,
                    "message" => "Category saved successfully.",
                ]);
            } else {
                return response()->json([
                    "status" => 0,
                    "message" => "Something Went Wrong !Try again",
                ]);
            }
        } else {
            return response()->json([
                "status" => 0,
                "message" => "Image Upload Failed ! try again",
            ]);
        }
    }
    public function AddProduct(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "product_name" => "required",
            "product_category_id" => "required",
            "product_image" => "required",
        ])->validate();

        $file = $request->file("product_image");
        $imageName = time() . "." . $file->extension();
        $imagePath = $imageName;
        $file->move("product_images", $imageName);
        if ($file) {
            $product = new Product();
            $product->product_name = $request->input("product_name");
            $product->product_category_id = $request->input(
                "product_category_id"
            );
            $product->product_image = $imagePath;
            $product->status = "1";
            if ($product->save()) {
                return response()->json([
                    "status" => 1,
                    "message" => "Product saved successfully.",
                ]);
            } else {
                return response()->json([
                    "status" => 0,
                    "message" => "Something Went Wrong !Try again",
                ]);
            }
        } else {
            return response()->json([
                "status" => 0,
                "message" => "Image Upload Failed ! try again",
            ]);
        }
    }
    public function update(Request $request)
    {
        try {
            $id = $request->input("id");
            $product = Product::find($id);

            if (!$product) {
                return response()->json(
                    [
                        "message" => "Product Not Found.",
                    ],
                    404
                );
            }

            $product->product_name = $request->product_name;
            $product->product_category_id = $request->product_category_id;

            if ($request->hasfile("product_image")) {
                $file = $request->file("product_image");
                $imageName = time() . "." . $file->extension();
                $imagePath = $imageName;
                if ($file->move("product_images", $imageName)) {
                    File::delete("product_images/" . $product->product_image);
                    //  unlink('product_images/'.$product->product_image);
                    $product->product_image = $imagePath;
                }
            }
            $product->save();
            return response()->json(
                [
                    "message" => "Product successfully updated.",
                ],
                200
            );
        } catch (\Exception $e) {
            return response()->json(
                [
                    "message" => "Something went really wrong!",
                ],
                500
            );
        }
    }
    public function ProductView($id)
    {
        if ($id != "") {
            $productDetails = Product::find($id);

            if ($productDetails) {
                $product = [
                    "id" => $productDetails->id,
                    "product_name" => $productDetails->product_name,
                    "category_id" => $productDetails->product_category_id,
                    "product_image" =>
                        "public/product_images/" .
                        $productDetails->product_image,
                ];

                return response()->json($product);
            } else {
                return response()->json([
                    "status" => 0,
                    "message" => "Product ID Not Found",
                ]);
            }
        } else {
            return response()->json([
                "status" => 0,
                "message" => "Product ID is required",
            ]);
        }
    }
    public function StoreBooking(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "customer_name" => "required",
            "product_id" => "required",
            "start_date" => "required",
            "start_time" => "required",
            "end_date" => "required",
            "end_time" => "required",
            "notes" => "required",
            "month" => "required",
            "year" => "required",
        ])->validate();

        if ($validator) {
            $booking = new Booking();
            $booking->customer_name = $request->input("customer_name");
            $booking->product_id = $request->input("product_id");
            $booking->start_date = $request->input("start_date");
            $booking->start_time = $request->input("start_time");
            $booking->end_date = $request->input("end_date");
            $booking->end_time = $request->input("end_time");
            $booking->notes = $request->input("notes");
            $booking->month = $request->input("month");
            $booking->year = $request->input("year");
            $booking->booking_status = "1";
            if ($booking->save()) {
                return response()->json([
                    "status" => 1,
                    "message" => "Booked successfully.",
                ]);
            } else {
                return response()->json([
                    "status" => 0,
                    "message" => "Something Went Wrong !Try again",
                ]);
            }
        }
    }

    public function BookingView(Request $request)
    {
        $id = $request->input("id");
        if ($id != "") {
            $bookingDetails = Booking::select(
                "id",
                "product_id",
                "customer_name",
                "start_date",
                "start_time",
                "end_date",
                "end_time",
                "notes"
            )
                ->where("product_id", "=", $id)
                ->where("booking_status", "=",1)
                ->get();

            if (count($bookingDetails) > 0) {
                return response()->json($bookingDetails);
            } else {
                return response()->json([
                    "status" => 0,
                    "message" => "No Bookings Found",
                ]);
            }
        } else {
            return response()->json([
                "status" => 0,
                "message" => "Product ID is required",
            ]);
        }
    }

    public function Register(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "username" => "required|min:2|max:100",
            "email" => "required|email",
            "password" => "required|min:6|max:100",
        ]);
        if ($validator->fails()) {
            return response()->json(
                [
                    "message" => "validation fails",
                    "errors" => $validator->errors(),
                ],
                422
            );
        }

        $user = User::create([
            "username" => $request->username,
            "email" => $request->email,
            "password" => Hash::make($request->password),
            "status" => 1,
        ]);

        return response()->json(
            [
                "message" => "Registration successfull",
                "data" => "",
            ],
            200
        );
    }

    public function Login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "email" => "required|email",
            "password" => "required",
        ]);
        if ($validator->fails()) {
            return response()->json(
                [
                    "massage" => "validation fails",
                    "errors" => $validator->errors(),
                ],
                422
            );
        }

        $user = User::where("email", $request->email)->first();
        if ($user && $user->status != "0") {
            if (Hash::check($request->password, $user->password)) {
                $users = User::select("id", "username", "email", "status")
                    ->where("email", $request->email)
                    ->first();
                return response()->json($users, 200);
            } else {
                $data = ["message" => "incorrect credentials", "status" => "0"];
                return response()->json($data, 400);
            }
        } else {
            $data = ["message" => "User Not Found", "status" => "0"];
            return response()->json($data, 400);
        }
    }

    public function Delete($id)
    {
        $product = Product::find($id);
        $product->status = 0;

        if ($product->save()) {
            return response()->json(
                [
                    "status" => 1,
                    "message" => "Deleted Successfully.",
                ],
                200
            );
        } else {
            return response()->json(
                [
                    "status" => 0,
                    "message" => "Something went wrong!.",
                ],
                200
            );
        }
    }
    
    
    //Booking Edit


    public function bookingupdate(Request $request)
    {
        try {

            $id=$request->input('id');
            $Booking = Booking::find($id);
           
            if(!$Booking){
              return response()->json([
                'message'=>'Booking Not Found.'
              ],404);
            }
     
            $Booking->product_id = $request->product_id;
            $Booking->customer_name = $request->customer_name;
            $Booking->start_date = $request->start_date;
            $Booking->start_time = $request->start_time;
            $Booking->end_date = $request->end_date;
            $Booking->end_time = $request->end_time;
            $Booking->notes = $request->notes;
            $Booking->month = $request->month;
            $Booking->year = $request->year;
     
        
            $Booking->save();
     
            
            return response()->json([
                'message' => "Booking successfully updated."
            ],200);
        } catch (\Exception $e) {
            
            return response()->json([
                'message' => "Something went wrong!"
            ],500);
        }
    }

    public function bookingdestroy($id)
    {
        $Booking = Booking::find($id);
        $Booking->booking_status = 0;

        if ($Booking->save()) {
            return response()->json(
                [
                    "booking_status" => 1,
                    "message" => "Deleted Successfully.",
                ],
                200
            );
        } else {
            return response()->json(
                [
                    "booking_status" => 0,
                    "message" => "Something went wrong!.",
                ],
                200
            );
        }
    }
    
//Filter Api

public function search(Request $request){
    $month=$request->input('month');
    $year=$request->input('year');
    $product_id=$request->input('product_id');
    if($month!="" && $year!="" && $product_id!=""){
    $bookingDetails=Booking::select('id','customer_name','product_id','start_date','start_time','end_date','end_time','notes','month','year',)->where('month','=',$month)->where('year','=',$year)->where('product_id','=',$product_id)->get();
   
    if(count($bookingDetails)>0){
         
      return response()->json($bookingDetails);
      
      }else{
      return response()->json([
            "status" => 0,
            "response"=>"",
            "message" => "No Bookings Found"
        ]);  
  }
      }else{

      return response()->json([
            "status" => 0,
            "response"=>"",
            "message" => "Booking Year Or Month is required"
        ]);  
      }
   }

    // public function EditProduct($id){

    //       if($id!=""){
    //     $productDetails=Product::find($id);

    //     if($productDetails){
    //         $product=array('id'=>$productDetails->id,
    //                     'product_name'=>$productDetails->product_name,
    //                     'category_id'=>$productDetails->product_category_id,
    //                     'product_image'=>'public/product_images/'.$productDetails->product_image,
    //                     'status'=>1,
    //                     'message'=>'');

    //       return response()->json($product);
    //   }else{
    //   return response()->json([
    //             "status" => 0,
    //             "message" => "Product ID Not Found"
    //         ]);
    //   }
    //       }else{

    //       return response()->json([
    //             "status" => 0,
    //             "message" => "Product ID is required"
    //         ]);
    //       }

    // }
}
